//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: example of MQ6822 as a I2C slave device
//******************************************
//******************************************
//Stack Pointer	=	0x23f (If use mq6822_32PinPackage_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 

#define   uchar    unsigned char


void delay(unsigned int Time)
{
	unsigned int i;

	for(i=Time;i>0;i--)
	{
		__asm("nop");
	}
}


void main()
{
	P2CR.bit.b3 = 0;
	P2CR.bit.b4 = 0;

	POFFCR1.bit.b4 = 1;		// enable I2C

	while(P2PRD.bit.b3==0||P2PRD.bit.b4==0);//wait for high level

	P2DR.byte    = 0xff;
	P2CR.bit.b3  = 1;
	P2CR.bit.b4  = 1;
	P2FC.bit.b3  = 1;
	P2FC.bit.b4  = 1;
	SBI0CR2.byte = 0x18;	// Selects the serial bus interface mode
	SBI0CR1.byte = 0x17;	// Selects the acknowledgment mode and sets SBI0CR1<SCK> to "110"
	I2C0AR.byte  = 0xa0;
	SBI0CR2.byte = 0x18;	// Selects the slave receiver mode

	WDCDR.byte = 0x4e;				// clear wdt
	__ASM("DI");
	ILH.bit.b7   = 0;
	EIRH.bit.b7  = 1;
	__ASM("EI");

	while(1)
	{
		WDCDR.byte = 0x4e;				// clear wdt
	}

}